%Note that the scripts in the Dependencies folder are required to run the
%script
clear
close all
fig_dir=pwd;
%Loads the duty cycle scan data
load('metadata_duty_800M.mat');
ref=load('ref_data_800M.mat');
fig_no=10;
x_min=0;
x_max=max(cellfun(@(x) max(x),x_mean));
x_vec=linspace(x_min,x_max,1e4);
color={'r','r','r'};

fig=figure(fig_no)
for i=1:length(y_mean)

    ax(i)=gca;
    
    %Scale factor used to displace the traces
    scale=10^(3-i);
    
    hold on
    %Plots only the selected part of the strobes for each trace
    plot(x_mean{i}(comb_ind{i}),y_mean{i}(comb_ind{i})/scale,'Color',color{i},'Marker','.',...
        'LineStyle','none','MarkerSize',4);
    hold on
    
    ref_line=plot(ref.x_mean,ref.y_mean/scale,'Color',[rgb('red'),0.3]);
    %     makePDF_klab(fig_no,5,5)
    
    xlabel('Time (s)')
    ylabel('Amplitude (normalized)')
    set(ax(i),'YScale','Log');
    axis([0,420,4e-4,1.3]);
    axis square
    box on
    plot(x_vec,fitdatas{i}(x_vec)/scale,'Color','k','LineStyle',':')
end
set(fig,'Color','w')
makePDF_klab(fig_no,sprintf('DutyStack'),6,6,fig_dir)